/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashSet;
import java.util.Set;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CantTouchBlueChallenge
extends Challenge {
    private static final Set<class_2248> BLUE_BLOCKS = new HashSet<class_2248>();
    private static final Set<class_1792> BLUE_ITEMS = new HashSet<class_1792>();
    private static final Set<class_1299<?>> BLUE_MOBS = new HashSet();
    private static final double MOB_CHECK_RADIUS = 0.75;

    public CantTouchBlueChallenge() {
        super("cant_touch_blue", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_blue.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_blue.description"), false, Challenge.MultiplayerStatus.EXPERIMENTAL);
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    public boolean isBlueBlock(class_2248 block) {
        return BLUE_BLOCKS.contains(block);
    }

    public boolean isBlueItem(class_1792 item) {
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            return this.isBlueBlock(block);
        }
        return BLUE_ITEMS.contains(item);
    }

    public boolean isBlueMob(class_1297 entity) {
        return BLUE_MOBS.contains(entity.method_5864());
    }

    public boolean isExplosionMode() {
        return ChallengeSettings.getBooleanOption(this.getId(), "explosion_mode", false);
    }

    public void setExplosionMode(boolean explosionMode) {
        ChallengeSettings.setBooleanOption(this.getId(), "explosion_mode", explosionMode);
    }

    public boolean isRainMode() {
        return ChallengeSettings.getBooleanOption(this.getId(), "rain_mode", true);
    }

    public void setRainMode(boolean rainMode) {
        ChallengeSettings.setBooleanOption(this.getId(), "rain_mode", rainMode);
    }

    private void killPlayer(class_1657 player, String deathType, String targetName) {
        class_1937 class_19372;
        if (this.isExplosionMode()) {
            this.createExplosion(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), 3.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)"challenges6t4.explosion.blue_touch"), true);
        } else if (player instanceof class_3222 && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            player.method_64397(serverWorld, serverWorld.method_48963().method_48831(), Float.MAX_VALUE);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.blue_touch." + deathType), (Object[])new Object[]{targetName}), true);
        } else {
            player.method_6033(0.0f);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.blue_touch." + deathType), (Object[])new Object[]{targetName}), true);
        }
    }

    public void createExplosion(class_1937 world, double x, double y, double z, float power) {
        world.method_8537(null, x, y, z, power, true, class_1937.class_7867.field_40891);
    }

    public boolean shouldKillPlayer(class_1657 player) {
        if (!this.isEnabled()) {
            return false;
        }
        class_2338 pos = player.method_24515();
        for (int y = 0; y <= 1; ++y) {
            class_2338 checkPos = pos.method_10086(y);
            class_2248 block = player.method_37908().method_8320(checkPos).method_26204();
            if (!BLUE_BLOCKS.contains(block)) continue;
            this.killPlayer(player, "block", block.method_9518().getString());
            return true;
        }
        class_2338 standingPos = class_2338.method_49637((double)player.method_23317(), (double)(player.method_23318() - 0.1), (double)player.method_23321());
        class_2248 standingBlock = player.method_37908().method_8320(standingPos).method_26204();
        if (BLUE_BLOCKS.contains(standingBlock)) {
            this.killPlayer(player, "block", standingBlock.method_9518().getString());
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !this.isBlueItem(stack.method_7909())) continue;
            this.killPlayer(player, "item", stack.method_7964().getString());
            return true;
        }
        class_238 checkBox = player.method_5829().method_1014(0.75);
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, checkBox)) {
            if (!this.isBlueMob(entity)) continue;
            this.killPlayer(player, "mob", entity.method_5477().getString());
            return true;
        }
        if (this.isRainMode() && player.method_37908().method_8419() && player.method_37908().method_8311(player.method_24515())) {
            this.killPlayer(player, "rain", "Rain");
            return true;
        }
        return false;
    }

    public void onAttackBlueMob(class_1657 player, class_1297 target) {
        if (this.isEnabled() && this.isBlueMob(target)) {
            this.killPlayer(player, "mob_attack", target.method_5477().getString());
        }
    }

    public void onTridentHit(class_1657 player) {
        if (this.isEnabled()) {
            this.killPlayer(player, "trident", "Trident");
        }
    }

    public void onRainHit(class_1657 player) {
        if (this.isEnabled() && this.isRainMode()) {
            this.killPlayer(player, "rain", "Rain");
        }
    }

    static {
        BLUE_BLOCKS.add(class_2246.field_10382);
        BLUE_BLOCKS.add(class_2246.field_10295);
        BLUE_BLOCKS.add(class_2246.field_10225);
        BLUE_BLOCKS.add(class_2246.field_10384);
        BLUE_BLOCKS.add(class_2246.field_10110);
        BLUE_BLOCKS.add(class_2246.field_10441);
        BLUE_BLOCKS.add(class_2246.field_10090);
        BLUE_BLOCKS.add(class_2246.field_29028);
        BLUE_BLOCKS.add(class_2246.field_10514);
        BLUE_BLOCKS.add(class_2246.field_10409);
        BLUE_BLOCKS.add(class_2246.field_10550);
        BLUE_BLOCKS.add(class_2246.field_10011);
        BLUE_BLOCKS.add(class_2246.field_10456);
        BLUE_BLOCKS.add(class_2246.field_10043);
        BLUE_BLOCKS.add(class_2246.field_10060);
        BLUE_BLOCKS.add(class_2246.field_9982);
        BLUE_BLOCKS.add(class_2246.field_10605);
        BLUE_BLOCKS.add(class_2246.field_10281);
        BLUE_BLOCKS.add(class_2246.field_10067);
        BLUE_BLOCKS.add(class_2246.field_10527);
        BLUE_BLOCKS.add(class_2246.field_27111);
        BLUE_BLOCKS.add(class_2246.field_27154);
        BLUE_BLOCKS.add(class_2246.field_10595);
        BLUE_BLOCKS.add(class_2246.field_10280);
        BLUE_BLOCKS.add(class_2246.field_10052);
        BLUE_BLOCKS.add(class_2246.field_10078);
        BLUE_BLOCKS.add(class_2246.field_10485);
        BLUE_BLOCKS.add(class_2246.field_10201);
        BLUE_BLOCKS.add(class_2246.field_10442);
        BLUE_BLOCKS.add(class_2246.field_29029);
        BLUE_BLOCKS.add(class_2246.field_10443);
        BLUE_BLOCKS.add(class_2246.field_22127);
        BLUE_BLOCKS.add(class_2246.field_22111);
        BLUE_BLOCKS.add(class_2246.field_22503);
        BLUE_BLOCKS.add(class_2246.field_22113);
        BLUE_BLOCKS.add(class_2246.field_22133);
        BLUE_BLOCKS.add(class_2246.field_22097);
        BLUE_BLOCKS.add(class_2246.field_22103);
        BLUE_BLOCKS.add(class_2246.field_22095);
        BLUE_BLOCKS.add(class_2246.field_22131);
        BLUE_BLOCKS.add(class_2246.field_22101);
        BLUE_BLOCKS.add(class_2246.field_22105);
        BLUE_BLOCKS.add(class_2246.field_22107);
        BLUE_BLOCKS.add(class_2246.field_22115);
        BLUE_BLOCKS.add(class_2246.field_22114);
        BLUE_BLOCKS.add(class_2246.field_22116);
        BLUE_BLOCKS.add(class_2246.field_23078);
        BLUE_BLOCKS.add(class_2246.field_23860);
        BLUE_BLOCKS.add(class_2246.field_22110);
        BLUE_BLOCKS.add(class_2246.field_22093);
        BLUE_BLOCKS.add(class_2246.field_22110);
        BLUE_BLOCKS.add(class_2246.field_10260);
        BLUE_BLOCKS.add(class_2246.field_47336);
        BLUE_BLOCKS.add(class_2246.field_48851);
        BLUE_BLOCKS.add(class_2246.field_37571);
        BLUE_BLOCKS.add(class_2246.field_37569);
        BLUE_BLOCKS.add(class_2246.field_37570);
        BLUE_BLOCKS.add(class_2246.field_37568);
        BLUE_BLOCKS.add(class_2246.field_28108);
        BLUE_BLOCKS.add(class_2246.field_43231);
        BLUE_BLOCKS.add(class_2246.field_10327);
        BLUE_BLOCKS.add(class_2246.field_10135);
        BLUE_BLOCKS.add(class_2246.field_10006);
        BLUE_BLOCKS.add(class_2246.field_10297);
        BLUE_BLOCKS.add(class_2246.field_10389);
        BLUE_BLOCKS.add(class_2246.field_10236);
        BLUE_BLOCKS.add(class_2246.field_10623);
        BLUE_BLOCKS.add(class_2246.field_10350);
        BLUE_BLOCKS.add(class_2246.field_10190);
        BLUE_BLOCKS.add(class_2246.field_10130);
        BLUE_BLOCKS.add(class_2246.field_10530);
        BLUE_BLOCKS.add(class_2246.field_10174);
        BLUE_BLOCKS.add(class_2246.field_9995);
        BLUE_BLOCKS.add(class_2246.field_10086);
        BLUE_ITEMS.add(class_1802.field_8759);
        BLUE_ITEMS.add(class_1802.field_8345);
        BLUE_ITEMS.add(class_1802.field_8273);
        BLUE_ITEMS.add(class_1802.field_8632);
        BLUE_ITEMS.add(class_1802.field_8705);
        BLUE_ITEMS.add(class_1802.field_8207);
        BLUE_ITEMS.add(class_1802.field_8547);
        BLUE_ITEMS.add(class_1802.field_8477);
        BLUE_ITEMS.add(class_1802.field_8377);
        BLUE_ITEMS.add(class_1802.field_8556);
        BLUE_ITEMS.add(class_1802.field_8250);
        BLUE_ITEMS.add(class_1802.field_8527);
        BLUE_ITEMS.add(class_1802.field_8802);
        BLUE_ITEMS.add(class_1802.field_8805);
        BLUE_ITEMS.add(class_1802.field_8058);
        BLUE_ITEMS.add(class_1802.field_8348);
        BLUE_ITEMS.add(class_1802.field_8285);
        BLUE_ITEMS.add(class_1802.field_8807);
        BLUE_ITEMS.add(class_1802.field_38747);
        BLUE_ITEMS.add(class_1802.field_38746);
        BLUE_MOBS.add(class_1299.field_6123);
        BLUE_MOBS.add(class_1299.field_6051);
        BLUE_MOBS.add(class_1299.field_6118);
        BLUE_MOBS.add(class_1299.field_6086);
        BLUE_MOBS.add(class_1299.field_6114);
        BLUE_MOBS.add(class_1299.field_28402);
        BLUE_MOBS.add(class_1299.field_6087);
        BLUE_MOBS.add(class_1299.field_6098);
        BLUE_MOBS.add(class_1299.field_17713);
        BLUE_MOBS.add(class_1299.field_6059);
        BLUE_MOBS.add(class_1299.field_38384);
        BLUE_MOBS.add(class_1299.field_6117);
        BLUE_MOBS.add(class_1299.field_38095);
        BLUE_MOBS.add(class_1299.field_47244);
        BLUE_MOBS.add(class_1299.field_6125);
    }
}

